﻿#include "PlayState.h"

char* convertIntToStr(int number)
{
	char* str = "";
	int i = 1;
	int temp = number;
	while (temp / 10 != 0)
	{
		temp = temp % 10;
		i++;
	}
	str = new char[i];
	for (int j = i - 1; j >= 0; j--)
	{
		int charnum = number % 10;
		str[j] = '0' + charnum;
		number = number / 10;
	}

	str[i] = '\0';
	return str;
}

PlayState::PlayState()
{
}

PlayState::~PlayState()
{
	for (int i = 0; i < BOARD_ROWS; i++)
	{
		delete[] m_Board[i];
	}
	delete[] m_Board;
}

PlayState::PlayState(IDStateGame id)
{
	m_ID = id;
}

void PlayState::Init()
{
	m_Score = 0;
	m_HeightBrick = 0;
	isPause = false;
	
	m_Board = new int*[BOARD_ROWS];
	for (int i = 0; i < BOARD_ROWS; i++)
	{
		m_Board[i] = new int[BOARD_COLLUMS];
	}

	for (int i = 0; i < BOARD_ROWS; i++)
	{
		for (int j = 0; j < BOARD_COLLUMS; j++)
		{
			m_Board[i][j] = 0;
		}
	}

	for (int i = 0; i < BOARD_COLLUMS; i++)
	{
		m_Board[49][i] = 2;
	}

	for (int i = 0; i < BOARD_ROWS - 1; i++)
	{
		m_Board[i][0] = 2;
		m_Board[i][30] = 2;
	}

	randomPiece();
}

void PlayState::Update()
{
	//Random MẢNH
	if (m_Piece->m_Status == STATUS::STOP)
	{
		//XOA CAI CŨ
		delete m_Piece;

		//TAO MANH MOI
		randomPiece();
	}

	//kt va cham ben phai va trai
	
	for (int i = 0; i < 4; i++)
	{
		int  row = m_Piece->m_Rectangle[i].y;
		int colr = m_Piece->m_Rectangle[i].x + 1;
		int coll = m_Piece->m_Rectangle[i].x - 1;

		//Cho nó là va chạm
		m_Piece->m_Status = STATUS::COLLIDE;

		if ((colr >= 0 && colr < BOARD_COLLUMS) && (row >= 0 && row < BOARD_ROWS) && (coll >= 0 && coll < BOARD_COLLUMS))
		{
			if (m_Board[row][coll] != 0 && m_Board[row][colr] != 0)
			{
				m_Piece->m_Collide = GDirections::NONE; //Dùng NONE CHO TH CHẠM 2 BÊN, ĐỠ PHẢI ĐỊNH NGHĨA THÊM :v
				break;									//break vì một trong các ô va chạm là nguyên mảnh va chạm
			}
			else
			{
				if (m_Board[row][colr] != 0 ) // || m_Board[row + 1][colr] != 0
				{
					m_Piece->m_Collide = GDirections::RIGHT;
					break;
				}
				else
				{
					if (m_Board[row][coll] != 0 ) // || m_Board[row + 1][coll] != 0
 					{
						m_Piece->m_Collide = GDirections::LEFT;
						break;
					}
					else
					{
						//Tất cả TH ko đúng thì nó ko va chạm
						m_Piece->m_Status = STATUS::MOVE;
					}
				}
			}

		}
	}

	//kt va cham duoi
	for (int i = 0; i < 4; i++)
	{
		//vi tri ke tiep cua rectangle
		int  y = m_Piece->m_Rectangle[i].y + 1;
		int x = m_Piece->m_Rectangle[i].x;

		if (y > 0 && y < BOARD_ROWS)
		{
			if (m_Board[y][x] != 0)
			{
				m_Piece->m_Status = STATUS::STOP;
			}
		}
		
	}

	//Nhấn nút
	if (GIsKeyPress(KEY_RIGHT))
		if (m_Piece->m_Status == STATUS::COLLIDE)
		{
			if (m_Piece->m_Collide != GDirections::NONE && m_Piece->m_Collide != GDirections::RIGHT)
			{
				m_Piece->m_Position.x++;
				m_Piece->m_Status = STATUS::MOVE;
			}
		}
		else
		{
			m_Piece->canDown = false;
			m_Piece->m_Position.x++;
		}
	else
		if (GIsKeyPress(KEY_LEFT))
		if (m_Piece->m_Status == STATUS::COLLIDE)
		{
			if (m_Piece->m_Collide != GDirections::NONE && m_Piece->m_Collide != GDirections::LEFT)
			{
				m_Piece->m_Position.x--;
				m_Piece->m_Status = STATUS::MOVE;
			}
		}
		else
		{
			m_Piece->canDown = false;
			m_Piece->m_Position.x--;
		}

	//cap nhat nhung manh da dung
	if (m_Piece->m_Status == STATUS::STOP)
	{
		for (int i = 0; i < 4; i++)
		{
			int row = m_Piece->m_Rectangle[i].y;
			int col = m_Piece->m_Rectangle[i].x;
			if (row > 0 && row < BOARD_ROWS)
			{
				m_Board[row][col] = m_Piece->getID();
			}
		}
	}

	//Update
	if (isPause == false)
		m_Piece->Update();

	//Score
	checkScored();

	//Check Die
	m_HeightBrick = checkHeight();
	if (m_HeightBrick >= 48)
	{
		StateManager::getInstance()->removeStateGame();
		StateManager::getInstance()->addStateGame(new EndState(IDStateGame::EXIT));
	}

	if (GIsKeyPress(KEY_ESC))
	{
		isPause = true;
		StateManager::getInstance()->addStateGame(new PauseState(IDStateGame::PAUSE));
	}
}

void PlayState::Draw()
{
	//Diem
	GPutStringToBuffer("Score", 32, 6);
	GPutStringToBuffer(convertIntToStr(m_Score),34,8);

	m_Piece->Draw();

	//ve ban
	for (int i = 0; i < BOARD_ROWS; i++)
	{
		for (int j = 0; j < BOARD_COLLUMS; j++)
		{
			GRectangle rect;
			rect.height = 0.5;
			rect.width = 0.5;
			rect.x = j;
			rect.y = i;
			
			switch (m_Board[i][j])
			{
			case 1:
			{
					  GDrawRect(rect, GColors::CYAN);
					  break;
			}
			case 2:
			{
					  GDrawRect(rect, GColors::LIGHT_CYAN);
					  break;
			}
			case 3:
			{
					  GDrawRect(rect, GColors::GREEN);
					  break;
			}
			case 4:
			{
					  GDrawRect(rect, GColors::LIGHT_MAGENTA);
					  break;
			}
			case 5:
			{
					  GDrawRect(rect, GColors::WHITE);
					  break;
			}
			case 6:
			{
					  GDrawRect(rect, GColors::LIGHT_RED);
					  break;
			}
			case 7:
			{
					  GDrawRect(rect, GColors::YELLOW);
					  break;
			}
			case 0:
				break;
			default:
				GDrawRect(rect, GColors::WHITE);
				break; 
			}
		}
	}
}

void PlayState::randomPiece()
{
	srand(time(0));
	switch (rand() % 7)
	{
	case 0:
	{
			  m_Piece = new IObject(IDObject::I);
			  m_Piece->Init();
			  break;
	}
	case 1:
	{
			  m_Piece = new JObject(IDObject::J);
			  m_Piece->Init();
			  break;
	}
	case 2:
	{
			  m_Piece = new LObject(IDObject::L);
			  m_Piece->Init();
			  break;
	}
	case 3:
	{
			  m_Piece = new OObject(IDObject::O);
			  m_Piece->Init();
			  break;
	}
	case 4:
	{
			  m_Piece = new NObject(IDObject::N);
			  m_Piece->Init();
			  break;
	}
	case 5:
	{
			  m_Piece = new ZObject(IDObject::Z);
			  m_Piece->Init();
			  break;
	}
	case 6:
	{
			  m_Piece = new TObject(IDObject::T);
			  m_Piece->Init();
			  break;
	}
	default:
		break;
	}
}

bool PlayState::checkScored()
{
	bool scored;
	for (int i = (BOARD_ROWS - 2); i >= 0; i--)
	{
		scored = true;
		for (int j = 1; j < BOARD_COLLUMS - 1; j++)
		{
			if (m_Board[i][j] == 0)
			{
				scored = false;
				break;
			}
		}
		if (scored)
		{
			m_Score++;

			//tạo 1 cái board tạm để lưu
			int **tempBoard;
			m_HeightBrick = checkHeight();
			int tempRow = m_HeightBrick - (BOARD_ROWS - i) + 1;

			tempBoard = new int*[tempRow];
			for (int row = 0; row < tempRow; row++)
			{
				tempBoard[row] = new int[BOARD_COLLUMS];
			}

			for (int row = 0; row < tempRow; row++)
			{
				for (int col = 0; col < BOARD_COLLUMS; col++)
				{
					tempBoard[row][col] = 0;
				}
			}

			//Lưu vào board tạm
			for (int row = 0; row < tempRow; row++)

			{
				for (int col = 1; col < BOARD_COLLUMS - 1; col++)
				{
					tempBoard[tempRow - row - 1][col] = m_Board[i - row - 1][col];
				}
			}

			//xóa từ dòng i của board
			for (int row = i; row >= 0; row--)
			{
				for (int col = 1; col < 30; col++)
				{
					m_Board[row][col] = 0;
				}
			}

			//cập nhật lại
			for (int row = i, row2 = tempRow - 1; row2 >=0 ; row--, row2--)
			{
				for (int col = 1; col < 30; col++)
				{
					m_Board[row][col] = tempBoard[row2][col];
				}
			}
				
			//xoa
			for (int row = 0; row < tempRow; row++)
			{
				delete[] tempBoard[row];
			}
			delete[] tempBoard;

			//Chieu cao giam 1
			m_HeightBrick--;
		}
	}
	return scored;
}

int PlayState::checkHeight()
{
	bool emptyRow = true;
	for (int row = BOARD_ROWS - 2 - m_HeightBrick; row >= 0; row--)
	{
		for (int col = 1; col < BOARD_COLLUMS - 1; col++)
		{
			if (m_Board[row][col] != 0)
			{
				emptyRow = false;
				break;
			}
		}
		if (emptyRow == false)
		{
			m_HeightBrick++;
			emptyRow = true;
		}
	}
	return m_HeightBrick;
}

void PlayState::PauseGame()
{
	isPause = true;
}

void PlayState::ResumeGame()
{
	isPause = false;
}